/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.cmdterm;

import com.quantumdata.std.IQDPluginContext;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.InstrumentResponse;
import com.quantumdata.std.RemoteInstrument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class QDCmdLine
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JComboBox m_request;
    private JLabel m_statusLine;
    private JTextArea m_text;
    private final int MAX_COUNT = 20;
    private RemoteInstrument m_instrument = null;
    private IQDPluginContext m_context;

    public QDCmdLine(IQDPluginContext iQDPluginContext) {
        this.m_context = iQDPluginContext;
        this.initComponents();
    }

    private void initComponents() {
        this.m_request = new JComboBox();
        this.m_statusLine = new JLabel();
        this.m_text = new JTextArea();
        this.setLayout(new BorderLayout(0, 5));
        this.m_request.setEditable(true);
        this.m_request.getEditor().setItem("<enter a CMD here>");
        JTextField jTextField = (JTextField)this.m_request.getEditor().getEditorComponent();
        jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QDCmdLine.this.RequestEntry(actionEvent);
            }
        });
        this.add((Component)this.m_request, "North");
        JPanel jPanel = new JPanel(new BorderLayout());
        JButton jButton = new JButton("Reconnect");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QDCmdLine.this.reconnect();
            }
        });
        jPanel.add((Component)jButton, "West");
        this.m_statusLine.setText("   ");
        jPanel.add((Component)this.m_statusLine, "Center");
        this.add((Component)jPanel, "South");
        JScrollPane jScrollPane = new JScrollPane();
        this.m_text.setBackground((Color)UIManager.getDefaults().get("Button.foreground"));
        this.m_text.setColumns(50);
        this.m_text.setEditable(false);
        this.m_text.setForeground(new Color(102, 255, 102));
        this.m_text.setRows(20);
        this.m_text.setTabSize(2);
        jScrollPane.setViewportView(this.m_text);
        this.add((Component)jScrollPane, "Center");
    }

    private void RequestEntry(ActionEvent actionEvent) {
        String string = (String)this.m_request.getEditor().getItem();
        this.m_text.append(string + "\r\n");
        InstrumentResponse instrumentResponse = this.m_instrument.sendCmd(string);
        this.m_text.append(instrumentResponse.getResponse() + "\r\n--> ");
        this.m_text.setCaretPosition(this.m_text.getText().length() - 1);
        if (this.m_request.getItemCount() == 20) {
            this.m_request.removeItemAt(0);
        }
        this.m_request.addItem(string);
        this.m_request.setSelectedIndex(this.m_request.getItemCount() - 1);
        this.m_request.getEditor().selectAll();
    }

    private void reconnect() {
        String string = "";
        this.m_instrument.disconnect();
        try {
            this.m_instrument.connect();
            string = "Connected";
        }
        catch (InstrumentException instrumentException) {
            this.m_request.addItem("*** Unable to reconnect\r\n");
            string = instrumentException.getMessage();
        }
        this.m_text.append(string + "\r\n--> ");
        this.m_text.setCaretPosition(this.m_text.getText().length() - 1);
        this.m_request.getEditor().selectAll();
    }

    public RemoteInstrument getInstrument() {
        return this.m_instrument;
    }

    public boolean close() {
        return true;
    }

    public void start() {
        this.m_instrument = this.m_context.getConnectionManager().getDefaultInstrument();
        this.m_request.getEditor().selectAll();
        this.m_text.setText("--> ");
    }
}

